--> pralable
-- USE BD_Air_France;


IF OBJECT_ID('dbo.T_affreter_aff','U') IS NOT NULL
   DROP TABLE dbo.T_affreter_aff;
GO
IF OBJECT_ID('dbo.T_avion_avi','U') IS NOT NULL
   DROP TABLE dbo.T_avion_avi;
GO
IF OBJECT_ID('dbo.T_Pilote_pil','U') IS NOT NULL
   DROP TABLE dbo.T_Pilote_pil;
GO
IF OBJECT_ID('dbo.T_compagnie_cmp','U') IS NOT NULL
   DROP TABLE dbo.T_compagnie_cmp;
GO


CREATE TABLE T_compagnie_cmp
(cmp_comp VARCHAR(4), cmp_effectif INT, cmp_ville VARCHAR(30), cmp_nom VARCHAR(30),
CONSTRAINT PK_cmp PRIMARY KEY(cmp_comp));
GO

CREATE TABLE T_Pilote_pil
 (pil_num      INT          NOT NULL UNIQUE,
  pil_prenom   VARCHAR(30)  NOT NULL,
  pil_nom      VARCHAR(60)  NOT NULL,
  pil_nbhvol   DECIMAL(7,2) CHECK (pil_nbhvol >= 1500),
  pil_code     SMALLINT     IDENTITY PRIMARY KEY,
  cmp_comp     VARCHAR(4)   FOREIGN KEY REFERENCES T_compagnie_cmp,
  pil_embauche DATE         DEFAULT (GETDATE()));

DROP TABLE T_Pilote_pil;
GO

CREATE TABLE T_Pilote_pil
 (pil_num      INT          CONSTRAINT nn_num NOT NULL 
                            CONSTRAINT un_num UNIQUE,
  pil_prenom   VARCHAR(30)  CONSTRAINT nn_prenom NOT NULL,
  pil_nom      VARCHAR(60)  CONSTRAINT nn_nom NOT NULL,
  pil_nbhvol   DECIMAL(7,2) CONSTRAINT ck_h_vol CHECK (pil_nbhvol >= 1500),
  pil_code     SMALLINT     IDENTITY CONSTRAINT pk_pil PRIMARY KEY,
  cmp_comp     VARCHAR(4)   CONSTRAINT fk_pil_comp
                                 FOREIGN KEY REFERENCES T_compagnie_cmp,
  pil_embauche DATE         CONSTRAINT dk_embauche DEFAULT (GETDATE()));


